-- Migration: Replace $value with $context.form in detail forms
-- This migration applies only to rows where baseForm ends with '-detail' or '-new'
-- Replaces all occurrences of "$value" with "$context.form" in the schema column

BEGIN;

-- ============================================================================
-- Preview changes (uncomment to test before applying)
-- ============================================================================
-- SELECT
--     id,
--     base_form,
--     schema AS old_schema,
--     replace(schema::text, '$value', '$context.form')::json AS new_schema
-- FROM config.cnft_form
-- WHERE schema IS NOT NULL
--   AND (base_form LIKE '%-detail' OR base_form LIKE '%-new')
--   AND schema::text LIKE '%$value%'
-- LIMIT 10;

-- ============================================================================
-- Apply the migration
-- ============================================================================
UPDATE config.cnft_form
SET schema = replace(schema::text, '$value', '$context.form')::json
WHERE schema IS NOT NULL
  AND (base_form LIKE '%-detail' OR base_form LIKE '%-new')
  AND schema::text LIKE '%$value%';

-- Report how many rows were updated
DO $do$
DECLARE
    updated_count INT;
BEGIN
    GET DIAGNOSTICS updated_count = ROW_COUNT;
    RAISE NOTICE 'Updated % rows in config.cnft_form for $value -> $context.form migration', updated_count;
END $do$;

COMMIT;
